function [outI1,outI2,outA1,outA2] = alignmentAugment(I1,I2,A1,A2, shiftStdDev)
%Shifts only the first image to create misalignment
% shift amount sampled from gaussian, crop and white pad
    [rows, cols, channels] = size(I1);
    shiftX = normrnd(0, shiftStdDev);
    shiftY = normrnd(0, shiftStdDev);
    tform = affine2d([ 1 0 0; 0 1 0; shiftX shiftY 1]);
    view = affineOutputView(size(I1),tform,'BoundsStyle','CenterOutput');
    outI1 = imwarp(I1, tform, 'FillValue', 255, 'OutputView',view);
    outI2 = I2;
    
    % apply transform to annotations
    annotation_tform = affine2d([ 1 0 0; 0 1 0; shiftX / cols shiftY / rows 1]);
    outA1 = affineAnnotations(A1, annotation_tform);
    outA2 = A2;
end

